package com.jcg.java9.functional.programming;

import java.util.List;

public class Test {

	/* Require Java 9 To Execute This Code. Please Download From Following Link - http://jdk.java.net/9/ */

	/* Object Oriented Programming Method */
	public String welcome(List<String> names) {
		String greeting = "Welcome ";
		for(String name : names) {
			greeting += name + " ";
		}
		greeting += "!";
		return greeting;
	}

	/* Functional Programming Method */
	public String greet(List<String> names) {
		String greeting = names.stream().map(name -> name + " ").reduce("Welcome ",(acc, name) -> acc + name);
		return greeting + "!";
	}

	/* Object Oriented Programming Method */
	public List<Integer> addOne(List<Integer> numbers) {
		List<Integer> plusOne = new LinkedList<>();
		for(Integer number : numbers) {
			plusOne.add(number + 1);
		}
		return plusOne;
	}

	/* Functional Programming Method */
	public List<Integer> addOne(List<Integer> numbers) {
		return numbers.stream().map(number -> number + 1).collect(Collectors.toList());
	}

	/* Object Oriented Programming Method */
	public Integer add(Integer a, Integer b) {
		return a + b;
	}

	/* Functional Programming Method */
	public void convertObjects() {
		Stream<String> objectStream = Stream.of("Hello", "World");
	}

	/* Functional Programming Method */
	public void convertStuff() {
		String[] array = {"apple", "banana"};
		Set<String> emptySet = new HashSet<>();
		List<Integer> emptyList = new LinkedList<>();

		Stream<String> arrayStream = Arrays.stream(array);
		Stream<String> setStream = emptySet.stream();
		Stream<Integer> listStream = emptyList.stream();
	}

	/* Functional Programming Method */
	public void showFlatMapLists() {
		List<Integer> numbers1 = Arrays.asList(1, 2, 3);
		List<Integer> numbers2 = Arrays.asList(4, 5, 6);

		Stream.of(numbers1, numbers2).flatMap(List::stream).forEach(System.out::println); 
	}
}